<?php
ob_start();
session_start();
include 'conexao.php';

// Buscar anos letivos disponíveis
$anos = $conn->query("SELECT DISTINCT ano_letivo FROM matriculas ORDER BY ano_letivo DESC")->fetch_all(MYSQLI_ASSOC);

// Buscar todos os alunos
$alunos = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerar Cartão de Estudante</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* Estilos globais e de fundo */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f2f5; /* Fundo cinza claro */
            margin: 0;
            padding: 0;
        }

        /* Barra superior */
        .navbar {
            background-color: #003366; /* Azul escuro */
            color: white;
            padding: 1rem;
            text-align: center;
            font-size: 1.5rem;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        }

        /* Container principal */
        .main-content {
            padding: 2rem;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        /* Estilização do card do formulário */
        .card-form {
            background: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            max-width: 600px;
            width: 100%;
            padding: 2rem;
        }

        /* Estilo para os labels */
        label {
            font-weight: 600;
            margin-top: 1rem;
            display: block;
            color: #333;
        }

        /* Estilo para os selects (melhor visibilidade) */
        select {
            width: 100%;
            padding: 0.75rem;
            margin-top: 0.5rem;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 1rem;
            background-color: #f9f9f9;
            color: #333;
            appearance: none; /* Remove estilo padrão em alguns browsers */
        }
        select:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
        }

        /* Estilo para a lista de alunos */
        #alunos_select {
            height: 200px; /* Altura fixa para a lista de alunos */
            border: 1px solid #ccc;
            border-radius: 5px;
            background-color: #fff;
            color: #333;
        }
        #alunos_select option {
            padding: 8px 12px;
            cursor: pointer;
        }
        #alunos_select option:checked {
            background-color: #007bff; /* Fundo azul para itens selecionados */
            color: white;
        }
        #alunos_select option:hover {
            background-color: #e2e6ea;
        }

        /* Botão de envio (mais visível) */
        .submit-button {
            width: 100%;
            padding: 0.75rem;
            margin-top: 1.5rem;
            background-color: #007bff; /* Azul vibrante */
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1.1rem;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .submit-button:hover {
            background-color: #0056b3; /* Azul mais escuro no hover */
        }

        /* Responsividade básica */
        @media (max-width: 768px) {
            .card-form {
                padding: 1.5rem;
            }
            .navbar {
                font-size: 1.2rem;
            }
        }
    </style>
</head>
<body>

<div class="navbar">
    Gerar Cartão de Estudante
</div>

<div class="main-content">
    <div class="card-form">
        <form method="post" action="gerar_cartoes.php" target="_blank">
            
            <label for="ano_letivo">Ano Letivo:</label>
            <select name="ano_letivo" required>
                <option value="">-- Selecione o Ano --</option>
                <?php foreach ($anos as $ano): ?>
                    <option value="<?= htmlspecialchars($ano['ano_letivo']) ?>"><?= htmlspecialchars($ano['ano_letivo']) ?></option>
                <?php endforeach; ?>
            </select>

            <label for="alunos">Alunos (pode selecionar até 6):</label>
            <select name="alunos[]" id="alunos_select" multiple size="6" required>
                <?php foreach ($alunos as $aluno): ?>
                    <option value="<?= htmlspecialchars($aluno['id']) ?>"><?= htmlspecialchars($aluno['nome']) ?></option>
                <?php endforeach; ?>
            </select>

            <button type="submit" class="submit-button">
                <i class="fas fa-print"></i> Gerar Cartões
            </button>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectElement = document.getElementById('alunos_select');
        const maxOptions = 6;

        selectElement.addEventListener('change', function() {
            const selectedOptions = Array.from(this.options).filter(option => option.selected);
            if (selectedOptions.length > maxOptions) {
                alert('Você só pode selecionar até ' + maxOptions + ' alunos.');
                selectedOptions[selectedOptions.length - 1].selected = false;
            }
        });
    });
</script>

</body>
</html>